import {BasicLayout, UserLayout} from '@/components/layouts'
import RouterNotFound from '@/views/exception/RouterNotFound'

const _import = require('@/util/import/_import_' + process.env.NODE_ENV)

/**
 * 基础路由
 * @type { *[] }
 */
export const constantRouterMap = [
  {
    path: '/user',
    component: UserLayout,
    redirect: '/user/login',
    hidden: true,
    children: [
      {
        path: 'login',
        name: 'login',
        component: () => import('@/views/user/Login')
      }
    ]
  },

  {
    path: '*',
    component: () => import('@/views/exception/404')
  }

]

/**
 * 动态路由生成
 * @param target
 * @param init
 * @returns {Array}
 */
export const initRouterTree = (target, init = []) => {
  for (let i = 0; i < target.length; i++) {
    let item = target[i]
    let routerItem = {
      meta: {}
    };
    routerItem.path = item.path
    routerItem.name = item.name
    routerItem.meta.title = item.title
    routerItem.hidden = item.hidden
    if (routerItem.path == '/') {
      routerItem.component = BasicLayout
    } else {
      try {
        routerItem.component = _import(item.componentPath)
      } catch (e) {
        routerItem.component = RouterNotFound
      }

    }
    if (item.redirect) {
      routerItem.redirect = item.redirect
    }
    if (item.icon) {
      routerItem.meta.icon = item.icon
    }
    if (item.permission) {
      routerItem.meta.permission = item.permission
    }
    if (item.keepAlive && item.keepAlive == true) {
      routerItem.meta.keepAlive = item.keepAlive
    }


    if (item.children) {
      routerItem.children = []
      initRouterTree(item.children, routerItem.children);
    }
    init.push(routerItem);
  }
  return init;
}
