import Vue from 'vue'
import App from './App.vue'
import Storage from 'vue-ls'
import router from './router/index'
import store from './store/'

import {VueAxios} from "@/util/axios/request"

import Antd from 'ant-design-vue'
import Viser from 'viser-vue'
import 'ant-design-vue/dist/antd.less'
import '@/util/global.js'
import appUtil from '@/util/app'
import { hasBtnPermission } from '@/util/util' // button permission

import {
  ACCESS_TOKEN
} from "@/store/mutation-types"
import config from '@/defaultSettings'

Vue.config.productionTip = false;
Vue.prototype.hasPerm = hasBtnPermission;

Vue.use(Storage, config.storageOptions)
Vue.use(Antd)
Vue.use(VueAxios, router)
Vue.use(Viser)
Vue.use(appUtil)

new Vue({
  router,
  store,
  mounted() {
    store.commit('SET_SIDEBAR_TYPE', true)
    store.commit('TOGGLE_THEME', config.navTheme)
    store.commit('TOGGLE_LAYOUT_MODE', config.layout)
    store.commit('TOGGLE_FIXED_HEADER', config.fixedHeader)
    store.commit('TOGGLE_FIXED_SIDERBAR', config.fixSiderbar)
    store.commit('TOGGLE_CONTENT_WIDTH', config.contentWidth)
    store.commit('TOGGLE_FIXED_HEADER_HIDDEN', config.autoHideHeader)
    store.commit('TOGGLE_WEAK', config.colorWeak)
    store.commit('TOGGLE_COLOR', config.primaryColor)
    store.commit('SET_TOKEN', Vue.ls.get(ACCESS_TOKEN))
  },
  render: h => h(App),
}).$mount('#app')