import {axios} from '@/util/axios/request'

const api = {
  getPage: '/sys/user/page',
  updateOne:'/sys/user/',
  resetPwd:'/sys/user/password/reset/',
  editPwd:'/sys/user/password/edit',
  deleteBatch:'/system/user/batchDelete',
  availableBatch:'/system/user/batchAvailable',
  changeStatus: '/sys/user/change/status/'
  // deleteWxUserRelation:'/system/user/delete/weixin/'
}

export default api

export function getPage(parameter) {
  return axios({
    url: api.getPage,
    method: 'post',
    data: parameter,
    useFullLoading: true
  })
}

/**
 * 启用
 * @param id
 */
export function getDetail(id) {
  return axios({
    url: api.updateOne + id,
    method: 'get',
    useFullLoading: true
  })
}

/**
 * 保存用户信息
 * @param data
 */
export function save(data) {
  return axios({
    url: api.updateOne,
    method: 'post',
    data: data,
    useFullLoading: true
  })
}

/**
 * 修改使用状态
 * @param id
 */
export function changeStatus(id) {
  return axios({
    url: api.changeStatus + id,
    method: 'get',
    useFullLoading: true
  })
}


/**
 * 批量禁用
 * @param id
 */
export function deleteBatch(parameter) {
  return axios({
    url: api.deleteBatch,
    method: 'put',
    data: parameter,
    useFullLoading: true
  })
}

/**
 * 批量禁用
 * @param id
 */
export function batchAvailable(parameter) {
  return axios({
    url: api.availableBatch,
    method: 'put',
    data: parameter,
    useFullLoading: true
  })
}

/**
 * 修改用户信息
 * @param id
 */
export function updateUserInfo(parameter) {
  return axios({
    url: api.updateOne,
    method: 'put',
    data: parameter,
    useFullLoading: true
  })
}

/**
 * 新增用户
 * @param id
 */
export function addUser(parameter) {
  return axios({
    url: api.updateOne,
    method: 'post',
    data: parameter,
    useFullLoading: true
  })
}

/**
 * 重置用户密码
 * @param id
 */
export function resetPwd(id) {
  return axios({
    url: api.resetPwd + id,
    method: 'get',
    useFullLoading: true
  })
}

/**
 * 修改用户密码
 * @param id
 */
export function editPwd(parameter) {
  return axios({
    url: api.editPwd,
    method: 'put',
    data:parameter,
    useFullLoading: true
  })
}

