import {axios} from '@/util/axios/request'

const api = {
  getPage: '/sys/role/page',
  getDetail: '/sys/role/',
  save: '/sys/role',
  changeStatus: '/sys/role/change/status/'
}

export default api

export function getPage(parameter) {
  return axios({
    url: api.getPage,
    method: 'post',
    data: parameter,
    useFullLoading: true
  })
}

export function getDetail(id) {
  return axios({
    url: api.getDetail + id,
    method: 'get',
    useFullLoading: true
  })
}

export function save(data) {
  return axios({
    url: api.save,
    method: 'post',
    data: data,
    useFullLoading: true
  })
}

/**
 * 修改使用状态
 * @param id
 */
export function changeStatus(id) {
  return axios({
    url: api.changeStatus + id,
    method: 'get',
    useFullLoading: true
  })
}
