import {axios} from '@/util/axios/request'

const api = {
  getPage: '/sys/code/type/page',
  getDetail: '/sys/code/type/',
  deleteOne: '/sys/code/type/',
  deleteBatch: '/sys/code/type/batchDelete',
  save: '/sys/code/type/',
  commCodePath: '/sys/code/type/code'
}

export default api

export function getPage(parameter) {
  return axios({
    url: api.getPage,
    method: 'post',
    data: parameter,
  })
}

export function getDetail(id) {
  return axios({
    url: api.getDetail + id,
    method: 'get',
    useFullLoading: true
  })
}

export function deleteOne(code) {
  return axios({
    url: api.deleteOne+code,
    method: 'delete'
  })
}

export function deleteBatch(parameter) {
  return axios({
    url: api.deleteBatch,
    method: 'post',
    data: parameter
  })
}

export function save(data) {
  return axios({
    url: api.save,
    method: 'post',
    data: data,
    useFullLoading: true
  })
}

export function getCommonCode(parameter) {
  return axios({
    url: api.commCodePath,
    method: 'post',
    data: parameter,
  })
}


