import {axios} from '@/util/axios/request'

const api = {
  getPage: '/holidays/page',
  synchronousVacation: '/holidays/synchronousVacation',
  deleteHoliday: '/holidays/',
  batchDeleteHoliday: '/holidays/batchDelete',
  addHoliday: '/holidays/add'
}

export default api

export function getPage(parameter) {
  return axios({
    url: api.getPage,
    method: 'post',
    data: parameter,
    useFullLoading: true
  })
}

export function synchronousVacation(parameter) {
  return axios({
    url: api.synchronousVacation,
    method: 'post',
    data: parameter,
    useFullLoading: true
  })
}

export function deleteHoliday(parameter) {
  return axios({
    url: api.deleteHoliday + parameter,
    method: 'delete',
    useFullLoading: true
  })
}

export function batchDeleteHoliday(parameter) {
  return axios({
    url: api.batchDeleteHoliday,
    method: 'post',
    data: parameter,
    useFullLoading: true
  })
}

export function addHoliday(parameter) {
  return axios({
    url: api.addHoliday,
    method: 'post',
    data: parameter,
    useFullLoading: true
  })
}