import {axios} from '@/util/axios/request';

const baseUrl = {
  // 工时
  taskEstimate: '/task-estimate', 
};


/**
 * 工时列表
 * @param {*} parameter 
 */
export function getPage(parameter) {
  return axios({
    url: `${baseUrl.taskEstimate}/consumed-page`,
    method: 'post',
    data: parameter,
    useFullLoading: true
  })
}

/**
 * 工时辅助信息
 */
export function getAuxiliaryInfo(month) {
  return axios({
    url: `${baseUrl.taskEstimate}/auxiliary-info/${month}`,
    method: 'get'
  });
}

/*
 * 导出工时表
 */
export function exportExcel(parameter) {
  return axios({
    responseType: 'blob',
    headers: {'Accept': 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'},
    url:  `${baseUrl.taskEstimate}/export`,
    method: 'post',
    data: parameter,
  })
}