import Vue from 'vue'
import {axios} from '@/util/axios/request'
import {ACCESS_TOKEN} from "@/store/mutation-types"

const api = {
  url: 'common/upload/file/',
  appUrl: 'common/upload/app/'
}

export function upload(file, business, type) {
  return axios({
    url: api.url + business + '/' + type,
    method: 'post',
    data: file,
    useFullLoading: true
  })
}

export function uploadApp(file, appType, version) {
  return axios({
    url: api.appUrl + appType + "/" + version,
    method: 'post',
    data: file,
    useFullLoading: true
  })
}


// 上传文件相关
export function getUploadImageHeader() {
  return {
    'Authorization': Vue.ls.get(ACCESS_TOKEN) || sessionStorage.getItem(ACCESS_TOKEN)
  }
}
export function getUploadAttachmentUrl(business) {
  return process.env.VUE_APP_URL + api.url + business + "/" + SYS_CONST.UPLOAD_TYPE.ATTACH
}
export function getUploadImageUrl(business) {
  return process.env.VUE_APP_URL + api.url + business + "/" + SYS_CONST.UPLOAD_TYPE.IMG
}

export function isUpdateSuccess(fileList) {
  let flag = true;
  if (fileList) {
    for(let i=0;i<fileList.length; i++) {
      if (fileList[i].response && fileList[i].response.code != SYS_CONST.REQUEST.SUCCEED) {
        fileList.splice(i,1)
        this.$notification.error({message: '系统提示', description: "上传失败,请重新上传！", duration: 4,});
        flag = false;
      }
    }
  }
  return flag;
}

export function getOneImageURL(imageList) {
  let image = '';
  let imageItem = imageList[0];
  if (imageItem && imageItem.response && imageItem.response.data && imageItem.response.data.url) {
    image = imageItem.response.data.url
  } else {
    if (imageItem && imageItem.url) {
      image = imageItem.url;
    }
  }
  return image;
}

export function getFileName(imageList) {
  let fileName = '';
  let imageItem = imageList[0];
  if (imageItem && imageItem.response && imageItem.response.data && imageItem.response.data.fileName) {
    fileName = imageItem.response.data.fileName
  } else {
    if (imageItem && imageItem.name) {
      fileName = imageItem.name;
    }
  }
  return fileName;
}
export function getImageUrlList(imageList) {
  let rulList = [];
  imageList.map(item => {
    if (item.response && item.response.data && item.response.data.url) {
      rulList.push(item.response.data.url)
    } else {
      if (item.url) {
        rulList.push(item.url);
      }
    }
  })
  return rulList;
}
export function isLoading(fileList) {
  let flag = false;
  for(let i=fileList.length-1; i>=0; i--) {
    if (!fileList[i].url && !fileList[i].response) {
      flag = true;
    }
  }
  return flag;
}
export function handleUploadChange(fileList) {
  let doneSize = fileList.length;
  for (let i = fileList.length - 1; i >= 0; i--) {
    let item = fileList[i];
    if (!item.status) {
      fileList.splice(i, 1)
      doneSize--;
    } else if (item.response && item.response.code != SYS_CONST.REQUEST.SUCCEED) {
      Vue.prototype.$message.error(item.name + ':文件上传失败！');
      fileList.splice(i, 1)
      doneSize--;
    } else if (item.status == "done") {
      doneSize--;
    }
  }
  return doneSize != 0;
}
//图片上传前验证，width、height不传则代表不限制像素
export function imgBeforeUpload(file, width, height) {
  let isImage = file.type.indexOf('image/') >= 0;
  let errorMsg = '';
  if (!isImage) {
    errorMsg += '不是图片类型';
  }
  let isLt1M = file.size / 1024 / 1024 < 1;
  if (!isLt1M) {
    errorMsg += errorMsg.length == 0 ? '文件大小不能超过1MB' : '；' + '文件大小不能超过1MB'
  }
  let result = isImage && isLt1M;
  if (!result) {
    Vue.prototype.$message.error(file.name + '：' + errorMsg + '！');
    return false;
  }
  if (width && height) {
    let promise = new Promise((resolve, reject) => {
      let image = new Image();
      let reader = new FileReader();
      reader.onload = () => {
        image.src = reader.result.toString();
      };
      image.onload = () => {
        if (image.naturalWidth != width || image.naturalHeight != height) {
          Vue.prototype.$message.error('图片尺寸必须为' + width + 'px *' + height + 'px!');
          reject();
        } else {
          resolve();
        }
      };
      reader.readAsDataURL(file);
    });
    return promise;
  }
  return true
}
// end上传文件相关