<#if isGenFileModule >
package ${currentPackage}.controller.${fileModule};

import ${entityPackage}.${fileModule}.${modelNameUpperCamel};
import ${currentPackage}.service.${fileModule}.${modelNameUpperCamel}Service;
<#else>
package ${currentPackage}.controller;

import ${daoPackage}.model.${modelNameUpperCamel};
import ${currentPackage}.service.${modelNameUpperCamel}Service;
</#if>

import ${corePackage}.result.Result;
import ${commonDaoPackage}.common.page.PageInfoVO;
import ${commonDaoPackage}.common.page.PageParams;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;

import static ${corePackage}.result.ResultGenerator.success;
import static ${corePackage}.result.ResultGenerator.fail;

/**
 * @author ${author}
 * @date ${date}
 * @description ${modelNameUpperCamel}Controller控制类
 */
@ApiIgnore
@Api(tags = "${modelNameUpperCamel}Controller")
@RestController
@RequestMapping("${requestMappingPath}")
@Validated
public class ${modelNameUpperCamel}Controller {

    @Resource
    private ${modelNameUpperCamel}Service ${modelNameLowerCamel}Service;


    @ApiOperation(value = "分页查询列表", notes = "作者: ${author}")
    @PostMapping("/page")
    public Result<PageInfoVO> getPage(@RequestBody @NonNull @Validated PageParams param) {
        return success(${modelNameLowerCamel}Service.getPage(param), "获取分页列表");
    }

    @ApiOperation(value = "根据id查询", notes = "作者: ${author}")
    @GetMapping("/{id}")
    public Result<${modelNameUpperCamel}> getDetails(@PathVariable @Positive Long id) {
        return success(${modelNameLowerCamel}Service.selectByPrimaryKey(id), "根据id获取详情");
    }

<#if isGenSaveOrUpdate >
    @ApiOperation(value = "新增或修改", notes = "作者: ${author}")
    @PostMapping("/save-or-update")
    public Result saveOrUpdate(@RequestBody @NonNull @Validated ${modelNameUpperCamel} ${modelNameLowerCamel}) {
        return success(${modelNameLowerCamel}Service.saveOrUpdate(${modelNameLowerCamel}), ${modelNameLowerCamel}.getId() == null ? "新增成功" : "修改成功");
    }
<#else>
    @ApiOperation(value = "新增", notes = "作者: ${author}")
    @PostMapping
    public Result save(@RequestBody @NonNull @Validated ${modelNameUpperCamel} ${modelNameLowerCamel}) {
        return success(${modelNameLowerCamel}Service.insertSelective(${modelNameLowerCamel}), "新增成功");
    }

    @ApiOperation(value = "修改", notes = "作者: ${author}")
    @PutMapping
    public Result update(@RequestBody @NonNull @Validated ${modelNameUpperCamel} ${modelNameLowerCamel}) {
        return success(${modelNameLowerCamel}Service.updateByPrimaryKeySelective(${modelNameLowerCamel}), "修改成功");
    }
</#if>

    @ApiOperation(value = "根据id删除", notes = "作者: ${author}")
    @DeleteMapping("/{id}")
    public Result deleteById(@PathVariable @Positive Long id) {
        return success(${modelNameLowerCamel}Service.deleteByPrimaryKey(id), "删除成功");
    }

}
