package com.onsiteservice.miniapp.service.user;

import com.onsiteservice.constant.constant.BizConstants;
import com.onsiteservice.constant.enums.BizCodeEnum;
import com.onsiteservice.core.exception.ServiceException;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.mapper.service.ServicePromoteMapper;
import com.onsiteservice.dao.mapper.user.UserMapper;
import com.onsiteservice.entity.service.ServicePromote;
import com.onsiteservice.entity.user.User;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Condition;

import javax.annotation.Resource;
import java.util.Objects;

@Service
@Transactional(rollbackFor = Exception.class)
public class ServicePromoteService extends AbstractMapper<ServicePromote> {

    @Resource
    private ServicePromoteMapper servicePromoteMapper;

    @Resource
    private UserMapper userMapper;

    public int promoteCount(Long userId) {

        User user = userMapper.selectByPrimaryKey(userId);
        if (Objects.isNull(user)) {
            throw new ServiceException(BizCodeEnum.USER_NOT_EXIST);
        }

        return servicePromoteMapper.promoteCount(userId);
    }

}
