package com.onsiteservice.miniapp.service.category;

import com.onsiteservice.core.result.Result;
import com.onsiteservice.core.result.ResultGenerator;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.mapper.service.ServiceSubclassMapper;
import com.onsiteservice.entity.category.ServiceSubclass;
import com.onsiteservice.miniapp.controller.category.vo.ServiceSubclassVO;
import com.onsiteservice.miniapp.mapper.category.ServiceSubclassBizMapper;
import com.onsiteservice.util.AttrCopyUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

@Service
@Slf4j
@Transactional(rollbackFor = Exception.class)
public class ServiceSubclassService extends AbstractMapper<ServiceSubclass> {

    @Resource
    private ServiceSubclassMapper serviceSubclassMapper;

    public Result<ServiceSubclassVO> getDetail(Long id) {
        log.info("subclass getDetail id: {}", id);

        ServiceSubclass serviceSubclass = serviceSubclassMapper.selectByPrimaryKey(id);
        return ResultGenerator.success(AttrCopyUtils.copy(serviceSubclass, new ServiceSubclassVO()));
    }

    /*public Result<PageInfoVO<ServiceSubclassVO>> getPage(PageServiceSubclassDTO dto) {
        PageHelper.startPage(dto.getPage(), dto.getSize());
        List<ServiceSubclass> serviceSubclassList = serviceSubclassBizMapper.selectServiceSubclassPage(dto);
        List<ServiceSubclassVO> serviceSubclassVOList = serviceSubclassList.parallelStream()
                .map(e -> AttrCopyUtils.copy(e, new ServiceSubclassVO())).collect(Collectors.toList());
        return ResultGenerator.success(new PageInfoVO<>(serviceSubclassVOList));
    }*/



}
