package com.onsiteservice.miniapp.job;

import com.onsiteservice.constant.constant.BizConstants;
import com.onsiteservice.constant.constant.SysParamConstants;
import com.onsiteservice.constant.enums.ServiceOrderOpSourceEnum;
import com.onsiteservice.constant.enums.ServiceOrderStatusEnum;
import com.onsiteservice.dao.component.RecordComponent;
import com.onsiteservice.dao.mapper.service.ServiceOrderMapper;
import com.onsiteservice.dao.mapper.sys.SysParamMapper;
import com.onsiteservice.entity.order.ServiceOrder;
import com.onsiteservice.entity.sys.SysParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Condition;

import javax.annotation.Resource;
import java.util.List;

/**
 * <P></P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/19 14:25
 */
@Service
@Transactional(rollbackFor = Exception.class)
@Slf4j
public class ServiceOrderCancelJob {


    private static final String MSG = "超时未付款自动取消";

    @Resource
    private ServiceOrderMapper serviceOrderMapper;

    @Resource
    private SysParamMapper sysParamMapper;

    @Resource
    private RecordComponent recordComponent;


    @Scheduled(cron = "0 * * * * *")
    public void cancelServiceOrder() {
        log.info("cancelServiceOrder start!");

        // 超时订单
        Condition c = new Condition(ServiceOrder.class);
        c.createCriteria().andEqualTo(BizConstants.OrderConstants.ORDER_STATUS, ServiceOrderStatusEnum.SEND.getStatus());
        List<ServiceOrder> serviceOrderList = serviceOrderMapper.selectByCondition(c);

        serviceOrderList.forEach(serviceOrder -> {
            if (System.currentTimeMillis() > serviceOrder.getCancelTime().getTime()) {
                serviceOrder.setOrderStatus(ServiceOrderStatusEnum.CANCEL.getStatus());
                serviceOrder.setRemark(MSG);
                int result = serviceOrderMapper.updateByPrimaryKey(serviceOrder);
                if (result == 1) {
                    log.info("cancelServiceOrder success serviceOrder: {}", serviceOrder);
                    recordComponent.recordProcess(serviceOrder.getId(), ServiceOrderStatusEnum.CANCEL.getStatus(), MSG, ServiceOrderOpSourceEnum.MINI_APP, null, null, null);
                }
            }
        });

    }

}
