package com.onsiteservice.miniapp.controller.worker;

import com.onsiteservice.core.result.Result;
import com.onsiteservice.miniapp.controller.worker.vo.ServiceValuatorVO;
import com.onsiteservice.miniapp.service.worker.ServiceValuatorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Positive;
import java.util.List;

import static com.onsiteservice.core.result.ResultGenerator.success;

/**
 * <P>估价员模块</P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/11 08:51
 */
@Api(tags = "估价员模块")
@RestController
@RequestMapping("/valuator/")
@Validated
public class ServiceValuatorController {

    @Resource
    private ServiceValuatorService serviceValuatorService;


    @ApiOperation(value = "查询全部估价员")
    @GetMapping("all")
    public Result<List<ServiceValuatorVO>> all() {
        return success(serviceValuatorService.all());
    }

    @ApiOperation(value = "根据姓名查询")
    @GetMapping("get")
    public Result<List<ServiceValuatorVO>> getDetails(@ApiParam(name = "name", value = "估价员姓名") @RequestParam(required = false) String name) {
        return success(serviceValuatorService.selectByName(name));
    }


}
