package com.onsiteservice.miniapp.controller.weixn;


import cn.binarywang.wx.miniapp.api.WxMaService;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.common.service.dto.MiniQrCodeDTO;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.miniapp.controller.weixn.dto.LoginDTO;
import com.onsiteservice.miniapp.controller.weixn.dto.WxEncryptDTO;
import com.onsiteservice.miniapp.service.weixin.WeiXinService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

import static com.onsiteservice.core.result.ResultGenerator.success;


/**
 *  微信相关Controller
 */
@ApiSupport(order = 2)
@Api(tags = "微信小程序")
@RestController
@RequestMapping("/weixin")
@Validated
@Slf4j
public class WeiXinController {

    @Resource
    private WxMaService wxMaService;
    @Resource
    private WeiXinService weiXinService;

    /**
     * 微信登录
     */
    @ApiOperation(value = "微信登录", notes = "作者: 潘维吉")
    @PostMapping("/login")
    public Result login(@RequestBody @Validated LoginDTO loginDTO) {
        return weiXinService.userLogin(loginDTO);
    }

    /**
     * 获取微信用户绑定手机号信息
     */
    @ApiOperation(value = "获取微信手机号", notes = "作者: 潘维吉")
    @PostMapping("/phone")
    public Result getPhone(@RequestBody @Validated WxEncryptDTO wxEncryptDTO, @CurrentUserId Long userId) {
        return success(weiXinService.getPhone(wxEncryptDTO, userId), "获取用户绑定手机号信息成功");
    }

    /**
     * 获取微信小程序码
     * 文档: https://developers.weixin.qq.com/miniprogram/dev/api-backend/open-api/qr-code/wxacode.getUnlimited.html
     */
    @ApiOperation(value = "获取微信小程序码", notes = "作者: 潘维吉")
    @PostMapping("/qr-code")
    public Result getQrCode(@RequestBody @NonNull @Validated MiniQrCodeDTO miniQrCodeDTO) {
        return weiXinService.getQrCode(miniQrCodeDTO);
    }

}
