package com.onsiteservice.miniapp.controller.weixn;

import com.onsiteservice.core.exception.ServiceException;
import com.onsiteservice.dao.mapper.pay.PayChannelWechatMapper;
import com.onsiteservice.miniapp.service.order.ServiceOrderBizService;
import com.onsiteservice.miniapp.service.weixin.pay.util.MD5Util;
import com.onsiteservice.miniapp.service.weixin.pay.util.MapUtil;
import com.onsiteservice.miniapp.service.weixin.pay.util.ParseXmlUtil;
import io.micrometer.core.instrument.util.StringUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Map;

/**
 * @author: qiaobin
 * @description:微信端支付回调
 * @date: 2019/1/22
 */
@ApiIgnore
@Controller
@RequestMapping("/wechat")
@AllArgsConstructor(onConstructor_ = {@Autowired})
@Slf4j
public class WechatNotifyController {

    private static final String RETURN_CODE_SUCCESS = "SUCCESS";

    private ServiceOrderBizService orderBizService;
    private PayChannelWechatMapper payChannelWechatMapper;

    /**
     * 服务器异步通知
     */
    @RequestMapping(value = "/pay-notify")
    public void notify(HttpServletRequest request, HttpServletResponse response) throws Exception {
        //WechatPayMyConfigMini config = new WechatPayMyConfigMini();
        PrintWriter out = null;
        try {
            log.info("微信支付成功回调通知开始！");
            StringBuffer sb = new StringBuffer();
            InputStream is = request.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String s = "";
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
            log.info("微信支付成功回调通知内容：" + sb.toString());
            if (StringUtils.isNotEmpty(sb.toString())) {
                // 解析xml
                Map<String, String> paramMap = ParseXmlUtil.parseXml2Map(sb.toString());
                String returnCode = paramMap.get("return_code").toString();
                log.info("微信支付成功返回result_code：" + returnCode);
                String outTradeNo = paramMap.get("out_trade_no").toString();

                 var payChannels = payChannelWechatMapper.selectAll();
                if (payChannels.isEmpty()) {
                    throw new ServiceException("未配置商户信息");
                }
                var payChannel = payChannels.get(0);
                String transactionId = paramMap.get("transaction_id").toString();
                //支付响应记录日志
//                savePayResponseLog(outTradeNo, transactionId, returnCode, sb.toString());
                if (RETURN_CODE_SUCCESS.equals(returnCode)) {
                    if (validateSign(paramMap, payChannel.getWechatKey())) {
                        //更新支付凭证支付状态
                        orderBizService.paySuccess(outTradeNo, sb.toString());
                                  out = response.getWriter();
                        // 通知微信，防止微信再通知
                        response.setContentType("application/xml");
                        out.write("<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>");
                        out.flush();
                        out.close();
                    } else {
                        log.warn("微信支付成功回调通知签名校验失败，请检查！");
                    }
                } else {
                    log.warn("微信支付成功回调通知返回码不成功(RETURN_CODE)，请检查！");
                }
            } else {
                log.warn("微信支付成功回调通知内容为空，请检查！");
            }

        } catch (Exception e) {
            log.error("notify() Exception exception:", e);
            e.printStackTrace();
        }
    }



    /**
     * 微信通知签名校验
     *
     * @param map
     * @param appKey
     * @return
     * @throws Exception
     */
    public boolean validateSign(Map<String, String> map, String appKey) throws Exception {
        //除去sign的信息
        String responseSign = map.get("sign").toString();//微信响应的sign
        map.remove("sign");
        String signStr = MapUtil.FormatBizQueryParaMap(map, false);
        signStr = signStr + "&key=" + appKey;
        String buildSign = MD5Util.MD5(signStr).toUpperCase();//根据key和报文生成的sign
        if (StringUtils.isEmpty(responseSign) || !buildSign.equals(responseSign)) {
            return false;
        }
        return true;
    }
}
