package com.onsiteservice.miniapp.controller.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

/**
 * <P></P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/15 10:51
 */
@Data
@ApiModel("发送验证码请求模型")
public class SendCodeDTO {

    @ApiModelProperty(value = "发送的手机号")
    @NotBlank(message = "请输入手机号")
    @Pattern(regexp = "^1[3456789]\\d{9}$", message = "手机号格式不正确")
    private String to;

}
