package com.onsiteservice.miniapp.controller.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

/**
 * <P></P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/15 10:51
 */
@Data
@ApiModel("绑定手机请求模型")
public class BindPhoneDTO {

    @ApiModelProperty(value = "验证码")
    @NotBlank(message = "验证码")
    private String code;


    @ApiModelProperty(value = "手机号")
    @NotBlank(message = "请输入手机号")
    @Pattern(regexp = "^1[3456789]\\d{9}$", message = "手机号格式不正确")
    private String phone;

}
