package com.onsiteservice.miniapp.controller.user;

import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.core.result.ResultGenerator;
import com.onsiteservice.miniapp.controller.user.dto.BindPhoneDTO;
import com.onsiteservice.miniapp.controller.user.dto.SendCodeDTO;
import com.onsiteservice.miniapp.controller.user.vo.UserInfoVO;
import com.onsiteservice.miniapp.service.user.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author 李宁
 * @date 2022-07-13 14:44
 */
@Api(tags = "用户模块")
@RestController
@RequestMapping("/user")
@Validated
public class UserController {


    @Resource
    private UserService userService;

    @ApiOperation(value = "绑定手机发送验证码", notes = "作者: 李宁")
    @PostMapping("send_code")
    public Result<String> sendCode(@RequestBody @NonNull @Validated SendCodeDTO dto) {
        return userService.sendCode(dto);
    }

    @ApiOperation(value = "换绑手机", notes = "作者: 李宁")
    @PostMapping("rebind")
    public Result<String> rebindPhone(@RequestBody @NonNull @Validated BindPhoneDTO dto, @CurrentUserId Long userId) {
        return userService.rebindPhone(dto, userId);
    }

    @ApiOperation("用户信息")
    @GetMapping("/info")
    public Result<UserInfoVO> getInfo(@CurrentUserId Long userId) {
        return ResultGenerator.success(userService.getInfo(userId));
    }

    @ApiOperation("用户身份 0 普通用户 1 客服 2 估价员 3 销售")
    @GetMapping("/role-type")
    public Result<Integer> getRoleType(HttpServletRequest request) {
        return ResultGenerator.success(userService.getRoleType(request));
    }


}
