package com.onsiteservice.miniapp.controller.order.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@ApiModel("订单默认信息值对象")
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ServiceOrderDefDetailVO {

    @ApiModelProperty(value = "地址id")
    private Long id;

    @ApiModelProperty(value = "客户姓名")
    private String name;

    @ApiModelProperty(value = "客户手机号")
    private String phone;

    @ApiModelProperty(value = "地址所在区域id")
    private Long areaId;

    @ApiModelProperty(value = "对应区域表name_path字段,例:山东省, 日照市, 东港区")
    private String namePath;

    @ApiModelProperty(value = "详细地址")
    private String address;

    @ApiModelProperty(value = "温馨提示")
    private String tips;

}