package com.onsiteservice.miniapp.controller.order.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Future;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;
import java.util.List;

@Data
@ApiModel("订单预约请求模型")
public class ReserveServiceOrderDTO {


    @ApiModelProperty(value = "服务子类id", required = true)
    @NotNull(message = "请选择服务类型")
    private Integer subclassId;

    /**
     * 服务地址id
     */
    @ApiModelProperty(value = "服务地址id", required = true)
    @NotNull(message = "请选择服务地址")
    private Long addressId;

    /**
     * 期望上门时间
     */
    @ApiModelProperty(value = "期望上门时间", required = true)
    @NotNull(message = "请选择上门时间")
    @Future(message = "上门时间必须为将来的某个时间点")
    private Date expectArrivalTime;

    /**
     * 服务数量
     */
    @ApiModelProperty(value = "服务数量", required = true)
    @NotNull(message = "请选择服务数量")
    @Min(value = 1, message = "服务数量最低为1")
    private Integer num;

    /**
     * 服务需求图片
     */
    @ApiModelProperty("服务需求图片")
    private String demandImg;

    /**
     * 服务需求说明
     */
    @ApiModelProperty("服务需求说明")
    private String demandDesc;

    /**
     * 是否阅读协议：1已阅读，0未阅读
     */
    @ApiModelProperty("是否阅读协议：1已阅读，0未阅读")
    @NotNull(message = "请确认是否阅读协议")
    private Boolean readAgreement;

    @ApiModelProperty("服务图片数组")
    @Size(max = 8, message = "最多上传8张图片")
    private List<String> urls;

}