package com.onsiteservice.miniapp.controller.common.vo;

import com.onsiteservice.miniapp.controller.category.vo.BannerVO;
import com.onsiteservice.miniapp.controller.category.vo.ServiceCategoryVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@ApiModel("首页轮播图")
public class HomeViewVO {

    @ApiModelProperty("轮播图")
    private List<BannerVO> bannerList;

    @ApiModelProperty("公告")
    private List<HomeNoticeVO> noticeList;

    @ApiModelProperty("服务")
    private List<ServiceCategoryVO> serviceList;

    @ApiModelProperty("0 普通用户 1 客服 2 估价员 3 销售")
    private Integer roleType;

}