package com.onsiteservice.miniapp.controller.address.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@Data
@ApiModel("保存服务地址请求模型")
public class SaveServiceAddressDTO {

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名", required = true)
    @NotBlank(message = "请输入联系人")
    private String name;

    /**
     * 手机或电话
     */
    @ApiModelProperty(value = "手机", required = true)
    @NotBlank(message = "请输入手机号")
    @Pattern(regexp = "^1[3456789]\\d{9}$", message = "手机号格式不正确")
    private String phone;

    /**
     * 区域id
     */
    @ApiModelProperty(value = "区域id", required = true)
    @NotNull(message = "请输入区域ID")
    private Long areaId;

    /**
     * 区域名称路径
     */
    @ApiModelProperty(value = "区域名称路径", required = true)
    @NotBlank(message = "请选择区域")
    private String namePath;

    /**
     * 地址
     */
    @ApiModelProperty(value = "地址", required = true)
    @NotBlank(message = "请输入详细地址")
    private String address;

//    @ApiModelProperty(value = "是否默认收货地址", required = true)
//    @NotNull(message = "请确认地址是否默认")
//    private Boolean def;

}