package com.onsiteservice.entity.user;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

@Builder
@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
@ToString
@ApiModel("用户表")
public class User implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    private static final long serialVersionUID = 1L;

    /**
     * 用户名
     */
    @Column(name = "user_name")
    @ApiModelProperty("用户名")
    private String userName;

    /**
     * 密码
     */
    @JSONField(serialize = false)
    @ApiModelProperty("密码")
    private String password;

    /**
     * 昵称
     */
    @Column(name = "nick_name")
    @ApiModelProperty("昵称")
    private String nickName;

    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty("邮箱")
    private String email;

    /**
     * 头像
     */
    @ApiModelProperty("头像")
    private String avatar;

    /**
     * 性别 0: 未知 1: 男 2: 女
     */
    @ApiModelProperty("性别 0: 未知 1: 男 2: 女")
    private Integer sex;

    /**
     * 同一用户，对同一个微信开放平台下的不同应用，unionId是相同的
     */
    @Column(name = "union_id")
    @ApiModelProperty("同一用户，对同一个微信开放平台下的不同应用，unionId是相同的")
    private String unionId;

    /**
     * 微信用户小程序openId  小程序内用户唯一标识
     */
    @Column(name = "open_id")
    @ApiModelProperty("微信用户小程序openId  小程序内用户唯一标识")
    private String openId;

    /**
     * 公众号openId  用于自定义推送消息
     */
    @Column(name = "official_account_open_id")
    @ApiModelProperty("公众号openId  用于自定义推送消息")
    private String officialAccountOpenId;
    /**
     * 即时通讯id
     */
    @Column(name = "im_user_id")
    @ApiModelProperty("即时通讯id")
    private String imUserId;

    @Column(name = "role_type")
    @ApiModelProperty("管理员")
    private Integer roleType;

    /**
     * 是否启用 0: 禁用 1: 启用
     */
    @Column(name = "is_enabled")
    @ApiModelProperty("是否启用 0: 禁用 1: 启用")
    private Boolean isEnabled;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    /**
     * 是否允许推送消息 0: 否 1: 是
     */
    @Column(name = "is_push_msg")
    @ApiModelProperty("是否允许推送消息 0: 否 1: 是")
    private Boolean isPushMsg;
}
