package com.onsiteservice.entity.base;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Builder
@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
@ToString
@ApiModel("性能表")
@Table(name = "base_pref")
public class BasePref implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 类型 1.api 2.sql
     */
    @ApiModelProperty("类型 1.api 2.sql")
    private Integer type;

    /**
     * 项目名称
     */
    @Column(name = "project_name")
    @ApiModelProperty("项目名称")
    private String projectName;

    /**
     * 运行环境
     */
    @ApiModelProperty("运行环境")
    private String environment;

    /**
     * 方法类型
     */
    @Column(name = "method_type")
    @ApiModelProperty("方法类型")
    private String methodType;

    /**
     * API路径
     */
    @Column(name = "api_path")
    @ApiModelProperty("API路径")
    private String apiPath;

    /**
     * 执行sql
     */
    @Column(name = "execute_sql")
    @ApiModelProperty("执行sql")
    private String executeSql;

    /**
     * 执行时间 单位ms
     */
    @Column(name = "execute_time")
    @ApiModelProperty("执行时间 单位ms")
    private Integer executeTime;

    /**
     * 运行平台
     */
    @ApiModelProperty("运行平台")
    private String platform;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}
