package com.onsiteservice.entity.address;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import tk.mybatis.mapper.annotation.LogicDelete;

@Getter
@Setter
@ToString
@ApiModel("服务地址表")
@Table(name = "service_address")
public class ServiceAddress implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 账号
     */
    @Column(name = "account_no")
    @ApiModelProperty("账号")
    private Long accountNo;

    /**
     * 姓名
     */
    @ApiModelProperty("姓名")
    private String name;

    /**
     * 手机或电话
     */
    @ApiModelProperty("手机或电话")
    private String phone;

    /**
     * 区域id
     */
    @ApiModelProperty("区域id")
    private Long areaId;

    /**
     * 区域名称路径
     */
    @ApiModelProperty("区域名称路径")
    private String namePath;

    /**
     * 地址
     */
    @ApiModelProperty("地址")
    private String address;

    /**
     * 是否默认：1默认地址，0非默认地址
     */
    @ApiModelProperty("是否默认：1默认地址，0非默认地址")
    private Boolean def;

    @LogicDelete
    @ApiModelProperty
    private Boolean deleted;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}