package com.onsiteservice.dao.util;

import lombok.experimental.UtilityClass;
import org.apache.commons.beanutils.ConvertUtils;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;

/**
 * @author 潘维吉
 * @date 2019/11/5 13:39
 * @email 406798106@qq.com
 * @description 数据库默认常用通用数据字段合并到Entity实体类属性
 */
@UtilityClass
public class EntityUtils {

    /**
     * 创建时对象赋值
     */
    public Object insert(Object entity) {
        Date now = new Date();
        return getBaseObject(entity, now);
    }

    /**
     * 创建时对象赋值
     */
    public Object insert(Object entity, Long userId) {
        Date now = new Date();
        EntityUtils.setFiledValue(entity, "createBy", userId);
        return getBaseObject(entity, now);
    }

    /**
     * 创建时对象赋值 用户id和用户名
     */
    public Object insert(Object entity, Long userId, String userName) {
        Date now = new Date();
        EntityUtils.setFiledValue(entity, "createBy", userId);
        EntityUtils.setFiledValue(entity, "createByName", userName);
        return getBaseObject(entity, now);
    }

    private static Object getBaseObject(Object obj, Date now) {
        EntityUtils.setFiledValue(obj, "version", 0);
        EntityUtils.setFiledValue(obj, "isDeleted", false);
        EntityUtils.setFiledValue(obj, "modifyTime", now);
        EntityUtils.setFiledValue(obj, "createTime", now);
        return obj;
    }

    /**
     * 创建时对象集合赋值
     */
    public List insert(List entityList, Long userId) {
        if (entityList != null) {
            for (Object o : entityList) {
                insert(o, userId);
            }
        }
        return entityList;
    }

    /**
     * 修改时对象赋值
     */
    public Object update(Object entity) {
        Date now = new Date();
        EntityUtils.setFiledValue(entity, "modifyTime", now);
        return entity;
    }

    /**
     * 修改时对象赋值 用户id
     */
    public Object update(Object entity, Long userId) {
        Date now = new Date();
        EntityUtils.setFiledValue(entity, "modifyBy", userId);
        EntityUtils.setFiledValue(entity, "modifyTime", now);
        return entity;
    }

    /**
     * 修改时对象赋值 用户id和用户名
     */
    public Object update(Object entity, Long userId, String userName) {
        Date now = new Date();
        EntityUtils.setFiledValue(entity, "modifyBy", userId);
        EntityUtils.setFiledValue(entity, "modifyTime", now);
        return entity;
    }

    /**
     * 修改时对象集合赋值
     */
    public List update(List entityList, Long userId) {
        if (entityList != null) {
            for (Object o : entityList) {
                update(o, userId);
            }
        }
        return entityList;
    }

    private void setFiledValue(Object o, String fieldName, Object value) {
        Field f = null;
        try {
            f = o.getClass().getDeclaredField(fieldName);
        } catch (NoSuchFieldException localNoSuchFieldException) {
        }
        if (f == null) {
            return;
        }
        f.setAccessible(true);
        try {
            f.set(o, ConvertUtils.convert(value, f.getType()));
        } catch (IllegalAccessException localIllegalAccessException) {
        }
    }

    private Object getFiledValue(Object o, String fieldName) {
        Field f = null;
        try {
            f = o.getClass().getDeclaredField(fieldName);
        } catch (NoSuchFieldException localNoSuchFieldException) {
        }
        if (f == null) {
            return null;
        }
        f.setAccessible(true);
        try {
            return f.get(o);
        } catch (IllegalAccessException localIllegalAccessException) {
        }
        return null;
    }

}
