package com.onsiteservice.dao.component;

import com.onsiteservice.constant.enums.ServiceOrderOpSourceEnum;
import com.onsiteservice.dao.mapper.service.ServiceOrderImgMapper;
import com.onsiteservice.dao.mapper.service.ServiceOrderLogMapper;
import com.onsiteservice.entity.order.ServiceOrder;
import com.onsiteservice.entity.service.ServiceOrderImg;
import com.onsiteservice.entity.service.ServiceOrderLog;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * <P></P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/14 10:08
 */
@Component
@Slf4j
public class RecordComponent {


    @Resource
    private ServiceOrderImgMapper serviceOrderImgMapper;

    @Resource
    private ServiceOrderLogMapper serviceOrderLogMapper;


    @Async
    public void recordServiceOrderImg(ServiceOrder serviceOrder, List<String> urls) {
        log.info("recordServiceOrderImg serviceOrder: {}, urls: {}", serviceOrder, urls);

        if (CollectionUtils.isEmpty(urls)) {
            return;
        }

        List<ServiceOrderImg> serviceOrderImgList = urls
                .parallelStream().map(url -> {
                    ServiceOrderImg serviceOrderImg = new ServiceOrderImg();
                    serviceOrderImg.setOrderId(serviceOrder.getId());
                    serviceOrderImg.setUrl(url);
                    serviceOrderImg.setCreateTime(new Date());
                    return serviceOrderImg;
                }).collect(Collectors.toList());

        serviceOrderImgMapper.insertList(serviceOrderImgList);
    }


    @Async
    public void recordProcess(Long orderId, Integer processId, String description, ServiceOrderOpSourceEnum sourceEnum, Long hostId, String remark, Date expectArrivalTime) {
        log.info("recordProcess orderId: {}, processId: {}, description: {}, sourceEnum: {}, hostId: {}, remark: {}, expectArrivalTime: {}",
                orderId, processId, description, sourceEnum, hostId, remark, expectArrivalTime);

        ServiceOrderLog serviceOrderLog = new ServiceOrderLog();
        serviceOrderLog.setOrderId(orderId);
        serviceOrderLog.setProcessId(processId);
        serviceOrderLog.setDescription(description);
        serviceOrderLog.setSource(sourceEnum.getId());
        serviceOrderLog.setHostId(hostId);
        serviceOrderLog.setRemark(remark);
        serviceOrderLog.setExpectArrivalTime(expectArrivalTime);

        serviceOrderLogMapper.insertSelective(serviceOrderLog);
    }


}
