package com.onsiteservice.core.result;

import org.springframework.util.ObjectUtils;

import javax.servlet.http.HttpServletResponse;

/**
 * @author 潘维吉
 * @date 2018-05-20
 * 响应结果统一生成工具
 * 含有成功和失败的各种响应数据情况
 */
public class ResultGenerator {

    /** 成功的msg默认提示  不添加失败的默认提示是强制开发者填写失败原因信息 返回默认无意义 */
    private static final String DEFAULT_SUCCESS_MESSAGE = "success";

    /**
     * 成功返回结果 默认
     */
    public static Result success() {
        return new Result()
                .setCode(ResultCodeEnum.SUCCESS)
                .setMsg(DEFAULT_SUCCESS_MESSAGE);
    }

    /**
     * 成功返回结果 只传入消息
     */
    public static Result success(String message) {
        return new Result()
                .setCode(ResultCodeEnum.SUCCESS)
                .setMsg(message);
    }

    /**
     * 成功返回结果 只传入数据
     */
    public static <T> Result<T> success(T data) {
        return new Result()
                .setCode(ResultCodeEnum.SUCCESS)
                .setData(data)
                .setMsg(DEFAULT_SUCCESS_MESSAGE);
    }

    /**
     * 成功返回结果 同时传入数据和消息
     */
    public static <T> Result<T> success(T data, String message) {
        return new Result()
                .setCode(ResultCodeEnum.SUCCESS)
                .setData(data)
                .setMsg(message);
    }

    /**
     * 失败返回结果 只传入失败消息
     */
    public static Result fail(String message) {
        return new Result()
                .setCode(ResultCodeEnum.FAIL)
                .setMsg(message);
    }

    /**
     * 失败返回结果 同时传入数据和消息
     */
    public static <T> Result<T> fail(T data, String message) {
        return new Result()
                .setCode(ResultCodeEnum.FAIL)
                .setData(data)
                .setMsg(message);
    }

    /**
     * 自定义code码 可用于每个错误类型唯一code码
     */
    public static <T> Result<T> failCustom(int code, String message) {
        return new Result()
                .setCode(code)
                .setMsg(message);
    }

    /**
     * 统一处理 成功返回结果 但数据为null或空字符串或空数组的情况下的msg信息
     */
    public static <T> Result<T> successEmpty(T data, String message) {
        if (ObjectUtils.isEmpty(data)) {
            message = "没有数据";
        }
        return new Result()
                .setCode(ResultCodeEnum.SUCCESS)
                .setData(data)
                .setMsg(message);
    }

    /**
     * 未认证
     */
    public static Result unauthorized(HttpServletResponse response) {
        response.setStatus(ResultCodeEnum.UNAUTHORIZED.getCode());
        return new Result()
                .setCode(ResultCodeEnum.UNAUTHORIZED)
                .setMsg("未认证");
    }
}
