package com.onsiteservice.core.result;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.io.Serializable;

/**
 * @author 潘维吉
 * @date 2018-05-20
 * API统一响应结果封装
 */
@ApiModel(description = "响应数据")
@Getter
public class Result<T> implements Serializable {

    /**
     * 响应码
     */
    @ApiModelProperty(value = "响应码(成功200, 失败400, 未认证401, 未授权403, 不存在404, 服务端错误500)", example = "200")
    private Integer code;

    /**
     * 响应数据
     */
    @ApiModelProperty(value = "响应数据")
    private T data;

    /**
     * 响应消息
     */
    @ApiModelProperty(value = "响应消息", example = "success")
    private String msg;

    public Result setCode(int code) {
        this.code = code;
        return this;
    }

    /**
     * 设置枚举状态码
     *
     * @param resultCode
     * @return
     */
    public Result setCode(ResultCodeEnum resultCode) {
        this.code = resultCode.getCode();
        return this;
    }

    public Result setData(T data) {
        this.data = data;
        return this;
    }

    public Result setMsg(String message) {
        this.msg = message;
        return this;
    }

    /**
     * 不使用@ToString注解  用FastJson打印data对象的详细信息
     *
     * @return Result
     */
    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
