package com.onsiteservice.core.config;

import com.onsiteservice.constant.constant.Constants;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

import javax.annotation.Resource;
import javax.servlet.MultipartConfigElement;

/**
 * @author 潘维吉
 * @date 2018-12-07 16:51
 * Servlet统一配置
 * Spring Boot自动配置一个开箱即用的DispatcherServlet，映射路径为‘/’，但是如果项目中有多个服务
 * 为了对不同服务进行不同的配置管理，需要对不同服务设置不同的上下文，比如开启一个DispatcherServlet专门用于rest服务
 */
@Deprecated
@ConditionalOnProperty(prefix = "project.servlet", name = {"enabled"}, matchIfMissing = false)
@Configuration
public class ServletConfig {

    /**
     * 自动注入spring boot上传配置
     */
    @Resource
    private MultipartConfigElement multipartConfigElement;

    /**
     * 增加一个servlet专门用于api地址访问 更灵活  url 上/api路径 可加可不加 都可以访问
     * 另一种方式设置servlet.context-path: /api 那应用下所有的资源都只能在contextPath目录下访问
     *
     * @param wac 是ApplicationContext的子接口
     * @return 自己注入的ServletRegistrationBean默认没有配置处理上传请求
     */
    @Bean
    public ServletRegistrationBean apiServletBean(WebApplicationContext wac) {
        //通过构造函数指定dispatcherServlet的上下文
        DispatcherServlet servlet = new DispatcherServlet(wac);
        //404 交给异常处理器处理
        servlet.setThrowExceptionIfNoHandlerFound(true);
        //用ServletRegistrationBean包装servlet
        ServletRegistrationBean bean = new ServletRegistrationBean(servlet);
        bean.setLoadOnStartup(1);
        //指定urlMapping 如 api/v1/*
        bean.addUrlMappings(Constants.REQUEST_PREFIX + "/*");
        //注入上传配置到自己注册的ServletRegistrationBean
        bean.setMultipartConfig(multipartConfigElement);
        //指定name，如果不指定默认为dispatcherServlet 为了不覆盖默认的dispatcherServlet，必须指定一个别的名称
        bean.setName("apiServlet");
        return bean;
    }
}
