package com.onsiteservice.constant.enums.core;

/**
 * @author 潘维吉
 * @date 2019-01-05 11:10
 * 枚举处理工具类
 */
public class EnumUtils {

    /**
     * 根据枚举code和枚举class获取枚举值
     */
    public static <T extends BaseEnum> T getEnumByCode(Integer code, Class<T> enumClass) {
        for (T e : enumClass.getEnumConstants()) {
            if (code.equals(e.getCode())) {
                return e;
            }
        }
        return null;
    }

    /**
     * 根据自定义枚举code和枚举class获取枚举值
     */
    public static <T extends BaseEnum> T getEnumByCustomCode(Integer code, Class<BaseEnum> baseEnum) {
        for (BaseEnum e : baseEnum.getEnumConstants()) {
            if (code.equals(e.getCode())) {
                return (T) e;
            }
        }
        return null;
    }
}
