package com.onsiteservice.constant.enums;


import com.onsiteservice.constant.enums.core.BaseEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;


/**
 * @author 潘维吉
 * @date 2018-12-29 14:18
 * 性别枚举类
 * VO中 新用法直接写 handler已自动类型映射处理 private SexEnum sex;
 */
@AllArgsConstructor
@Getter
public enum SexEnum implements BaseEnum<SexEnum, String> {

    UNKNOWN(0, "未知"),
    MAN(1, "男"),
    WOMAN(2, "女");

    private final int code;
    private final String value;

    /**
     * 重写toString方法 用于自定义枚举返回数据和格式
     *
     * @return 自定义枚举数据
     */
    @Override
    public String toString() {
        return "{'code':" + this.code + ",'value':'" + this.value + "'}";
    }
}
