package com.onsiteservice.constant.enums;

import lombok.Getter;

/**
 * <P>订单状态枚举</P>
 *
 * @author jack
 * @version v1.0
 * @since 2022/4/11 15:42
 */
public enum ServiceOrderStatusEnum {


    /**
     * 已提交
     */
    RESERVE(1, "用户已下单"),

    /**
     * 已受理:估价+发送客户
     */
    VALUATION(2, "客服: %s 已派估价员 %s"),
    REVALUATION(2, "客服: %s 已重新派估价员 %s"),

    /**
     * 已发送
     */
    SEND(3, "%s 已发送订单信息"),

    /**
     * 已支付
     */
    PAY(4, "用户已付款"),

    /**
     * 已派单
     */
    DISPATCH(5, "客服: %s 已派维修工 %s"),
    REDISPATCH(5, "客服: %s 已重新派维修工 %s"),

    /**
     * 已确认
     */
    FINISH(6, "%s 已确认完成服务"),

    /**
     * 取消订单
     */
    CANCEL(7, "用户已取消订单"),

    /**
     * 退款状态
     */
    REFUND_APPLY(8,"申请退款"),
    REFUND_HANDLING(9,"退款处理中"),
    REFUND_FAIL(10,"退款失败"),
    REFUND_FINISH(11,"退款完成");


    @Getter
    private Integer status;

    @Getter
    private String msg;


    private ServiceOrderStatusEnum(Integer status, String msg) {
        this.status = status;
        this.msg = msg;
    }


}
