package com.onsiteservice.constant.enums;

import com.onsiteservice.constant.enums.core.BaseEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author 潘维吉
 * @date 2020/3/27 15:04
 * @email 406798106@qq.com
 * @description 字典枚举类
 * 多个枚举放在一个类中维护
 */
@Deprecated
public class DictEnum {

    @AllArgsConstructor
    @Getter
    public enum StatusEnum implements BaseEnum<StatusEnum, String> {

        DISABLE(0, "禁用"),
        ENABLE(1, "启用");

        private final int code;
        private final String value;

        /**
         * 重写toString方法 用于自定义枚举返回数据和格式
         *
         * @return 自定义枚举数据
         */
        @Override
        public String toString() {
            return "{'code':" + this.code + ",'value':'" + this.value + "'}";
        }
    }

}
