package com.onsiteservice.util.i18n;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * @author 潘维吉
 * @date 2019-03-18 9:40
 * 国际化工具类
 * URL ?lang=zh_CH or &lang=en_US
 */
@Component
public class I18nUtils {

    /** 维护一个本类的静态变量 */
    public static I18nUtils i18nUtil;
    @Autowired
    private MessageSource messageSource;

    /**
     * 获取国际化值
     */
    public static String get(String msgKey) {
        try {
            return i18nUtil.messageSource.getMessage(msgKey, null, LocaleContextHolder.getLocale());
        } catch (Exception e) {
            return msgKey;
        }
    }

    /** 初始化的时候，将本类中的messageSource赋值给静态的本类变量 */
    @PostConstruct
    public void init() {
        i18nUtil = this;
        i18nUtil.messageSource = this.messageSource;
    }
}
