package com.onsiteservice.util.i18n;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

import java.util.Locale;

/**
 * @author 潘维吉
 * @date 2019-03-18 9:35
 * 配置国际化语言
 * yaml文件配置
 * messages:
 * # 指定message的basename，多个以逗号分隔，如果不加包名的话，默认从classpath路径开始，默认: messages
 * basename: i18n/messages, i18n/business/messages
 * encoding: UTF-8
 * # 设定加载的资源文件缓存失效时间，-1的话为永不过期，默认为-1
 * cache-duration: -1
 */
@ConditionalOnProperty(prefix = "project.i18n", name = {"enabled"}, matchIfMissing = false)
@Configuration
public class I18nConfig {

    /**
     * 默认解析器 其中locale表示默认语言
     */
    @Bean
    public LocaleResolver localeResolver() {
        SessionLocaleResolver localeResolver = new SessionLocaleResolver();
        // 默认语言
        localeResolver.setDefaultLocale(Locale.CHINESE);
        return localeResolver;
    }

    /**
     * 默认拦截器 切换国际化语言的参数名
     * 其中lang表示切换语言的参数名 URL?lang=en_US 表示读取国际化文件messages_en_US.properties
     */
    @Bean
    public WebMvcConfigurer localeInterceptor() {
        return new WebMvcConfigurer() {
            @Override
            public void addInterceptors(InterceptorRegistry registry) {
                LocaleChangeInterceptor localeInterceptor = new LocaleChangeInterceptor();
                // 参数名
                localeInterceptor.setParamName("lang");
                registry.addInterceptor(localeInterceptor);
            }
        };
    }

/*    @Bean
    public Properties yamlProperties() {
        YamlPropertiesFactoryBean bean = new YamlPropertiesFactoryBean();
        bean.setResources(new ClassPathResource("i18n/messages.yaml"));
        return bean.getObject();
    }

    @Bean
    public MessageSource messageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setCommonMessages(yamlProperties());
        return messageSource;
    }*/
}
