package com.onsiteservice.util.aliyun;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

/**
 * @author 潘维吉
 * @date 2020/4/28 14:49
 * @email 406798106@qq.com
 * @description 阿里云墨迹天气服务
 */
@Slf4j
public class WeatherUtils {
    private static final String APP_CODE = "bc61a7e5d9f444fb96db387dedd19a55";

    private static final RestTemplate restTemplate = new RestTemplate();


    public static Map getWeatherByLocation(String longitude, String latitude) {
        String host = "http://aliv1.data.moji.com";
        String path = "/whapi/json/aliweather/briefcondition";

        HttpHeaders requestHeaders = new HttpHeaders();
        //最后在header中的格式(中间是英文空格)为Authorization:APPCODE 83359fd73fe94948385f570e3c139105
        requestHeaders.add("Authorization", "APPCODE " + APP_CODE);
        //根据API的要求，定义相对应的Content-Type
        requestHeaders.add("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");

        MultiValueMap<String, String> requestBody = new LinkedMultiValueMap<>();
        requestBody.add("lon", longitude);
        requestBody.add("lat", latitude);
        requestBody.add("token", "a231972c3e7ba6b33d8ec71fd4774f5e");

        HttpEntity<MultiValueMap> requestEntity = new HttpEntity<MultiValueMap>(requestBody, requestHeaders);
        ResponseEntity responseEntity = restTemplate.postForEntity(host + path, requestEntity, String.class);
        String result = (String) responseEntity.getBody();
        //result内容：{"code":0,"data":{"city":
        // {"cityId":284996,"counname":"中国","ianatimezone":"Asia/Shanghai","name":"东港区","pname":"山东省","secondaryname":"日照市","timezone":"8"},
        // "condition":{"condition":"晴","humidity":"20","icon":"0","temp":"23","updatetime":"2020-04-28 15:30:08","vis":"24069","windDegrees":"225","windDir":"西南风","windLevel":"4"}},"msg":"success","rc":{"c":0,"p":"success"}}
        log.info(result);
        return JSON.parseObject(result, Map.class);

    }

    public static void main(String[] args) {
        // 配合redis进行定期缓存 减少调用次数
        getWeatherByLocation("119.5270362600", "35.4163702200");
    }

}
