package com.onsiteservice.common.redis;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;

import java.nio.charset.Charset;

/**
 * @author 潘维吉
 * @date 2019/12/5 9:23
 * @email 406798106@qq.com
 * @description 统一添加Redis key前缀  注入到RedisConfig中setKeySerializer
 */
//@Component //需要时开启
@Slf4j
public class KeyStringRedisSerializer implements RedisSerializer<String> {

    private final Charset charset;
    @Value("${spring.cache.redis.key-prefix:''}")
    private String keyPrefix;

    public KeyStringRedisSerializer() {
        this(Charset.forName("UTF8"));
    }

    public KeyStringRedisSerializer(Charset charset) {
        Assert.notNull(charset, "Charset must not be null!");
        this.charset = charset;
    }

    @Override
    public String deserialize(byte[] bytes) {

        String saveKey = new String(bytes, charset);
        int indexOf = saveKey.indexOf(keyPrefix);
        if (indexOf > 0) {
            log.info("key缺少前缀");
        } else {
            saveKey = saveKey.substring(indexOf);
        }
        log.info("saveKey:{}", saveKey);
        return (saveKey.getBytes() == null ? null : saveKey);
    }

    @Override
    public byte[] serialize(String string) {
        String key = keyPrefix + string;
        log.info("key:{},getBytes:{}", key, key.getBytes(charset));
        return (key == null ? null : key.getBytes(charset));
    }
}
