package com.onsiteservice.common.order.vo;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@ApiModel("订单值对象")
public class ServiceOrderVO {

    @ApiModelProperty(value = "订单id")
    private Long id;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "服务名")
    private String serviceName;

    @ApiModelProperty(value = "服务标题")
    private String serviceSubclassName;

    @ApiModelProperty(value = "客户名")
    private String name;
    @ApiModelProperty(value = "客户手机号")
    private String phone;
    @ApiModelProperty(value = "客户下单服务地址")
    private String address;

    @ApiModelProperty(value = "期望上门时间")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date expectArrivalTime;

    @ApiModelProperty(value = "服务数量")
    private Integer num;

    @ApiModelProperty(value = "子类服务图片,待受理标题图片url地址")
    private String subclassImg;

    @ApiModelProperty(value = "服务说明")
    private String demandDesc;

    @ApiModelProperty(value = "下单备注信息")
    private String remark;

    @ApiModelProperty(value = "订单创建时间")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty(value = "订单付款剩余时间")
    private Long leftTime;

    @ApiModelProperty(value = "客户上传需求图片,最多8张")
    private List<String> demandImgUrls;

    @ApiModelProperty(value = "订单流程信息")
    private List<ServiceOrderLogVO> process;

    @ApiModelProperty(value = "订单状态 1待受理,2 已拍估价员 3待支付,4待派单,5服务中,6已完成，7已取消 ")
    private String orderStatus;

    @ApiModelProperty(value = "价格")
    private BigDecimal price;

}