package com.onsiteservice.common.config;


import com.onsiteservice.common.annotation.idempotent.ApiIdempotentInterceptor;
import com.onsiteservice.common.annotation.user.CurrentUserIdResolver;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author 潘维吉
 * @date 2019-05-20
 * MVC 通用统一配置
 */
@Configuration
@Slf4j
public class CommonConfig implements WebMvcConfigurer {

    @Resource
    private ApiIdempotentInterceptor apiIdempotentInterceptor;
    @Resource
    private CurrentUserIdResolver currentUserIdResolver;

    /**
     * 添加拦截器
     */
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(apiIdempotentInterceptor);
    }

    /**
     * 添加参数解析器
     */
    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(currentUserIdResolver);
    }


    /**
     * 添加全局请求参数类型转换器和格式化器
     * 通过覆盖addFormatter方法来实现对Converter和ConverterFactory的绑定
     *
     * @param registry
     */
    @Override
    public void addFormatters(FormatterRegistry registry) {
        //给当前的Spring容器中添加自定义格式转换器
        // registry.addConverter(new StringToDateConverter());
        // registry.addConverter(new BooleanToNumberConverter());
    }


}
