package com.onsiteservice.common.annotation.limit;

import java.lang.annotation.*;
import java.util.concurrent.TimeUnit;

/**
 * @author 潘维吉
 * @date 2020/3/13 10:45
 * @email 406798106@qq.com
 * @description API接口限流注解
 * 令牌桶算法 会以一个恒定的速率向固定容量大小桶中放入令牌，当有浏览来时取走一个或者多个令牌
 * 当发生高并发情况下拿到令牌的执行业务逻辑,没有获取到令牌的就会丢弃获取服务降级处理,提示一个友好的错误信息给用户
 * @RateLimit(permitsPerSecond = 1,  msg = "亲 , 现在流量过大 , 请稍后再试")
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
@Documented
public @interface RateLimit {

    // 以固定数值往令牌桶添加令牌 每秒不要超过多少个
    double permitsPerSecond() default 10;

    // 获取令牌最大等待时间
    long timeout() default 500;

    // 单位(例:分钟/秒/毫秒) 默认:毫秒
    TimeUnit timeunit() default TimeUnit.MILLISECONDS;

    // 无法获取令牌返回提示信息 默认值可以自行修改
    String msg() default "系统繁忙 , 请稍后再试";
}
