package com.onsiteservice.admin.service.user;

import com.onsiteservice.admin.controller.user.dto.UserPageDTO;
import com.onsiteservice.constant.enums.ServiceUserTypeEnum;
import com.onsiteservice.dao.mapper.service.ServicePromoteMapper;
import com.onsiteservice.dao.util.EntityUtils;
import com.onsiteservice.entity.service.ServicePromote;
import com.onsiteservice.entity.user.User;
import com.onsiteservice.dao.mapper.user.UserMapper;
import com.onsiteservice.admin.mapper.user.UserBizMapper;

import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.github.pagehelper.PageHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * @author 商天翔
 * @date 2022-07-13 14:44
 * @description UserService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class UserService extends AbstractMapper<User> {

    @Resource
    private UserMapper userMapper;
    @Resource
    private UserBizMapper userBizMapper;
    @Resource
    private ServicePromoteMapper servicePromoteMapper;

    /**
     * 分页查询列表
     */
    public PageInfoVO getPage(UserPageDTO dto) {
        PageHelper.startPage(dto.getPage(), dto.getSize());
        return new PageInfoVO(userBizMapper.getPage(dto));
    }

    /**
     * 保存或更新方法
     */
    public int update(User user, Long userId) {
        EntityUtils.update(user, userId);
        if(ServiceUserTypeEnum.SALES.getId().equals(user.getRoleType())) {
            ServicePromote condition = new ServicePromote();
            condition.setAccountNo(user.getId());
            var promote = servicePromoteMapper.selectOne(condition);
            if(promote == null) {
                var modifyUser = userMapper.selectByPrimaryKey(user.getId());
                promote = condition;
                promote.setCount(0);
                promote.setUserName(modifyUser.getUserName());
                EntityUtils.insert(promote, userId);
                servicePromoteMapper.insert(promote);
            }
        }
        return this.updateByPrimaryKeySelective(user);
    }
}
