package com.onsiteservice.admin.service.sys;

import com.github.pagehelper.PageHelper;
import com.onsiteservice.admin.mapper.sys.SysUserRoleBizMapper;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.dao.mapper.sys.SysUserRoleMapper;
import com.onsiteservice.entity.sys.SysUserRole;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author wang jianguo
 * @date 2021-07-22 17:53
 * SysUserRoleService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SysUserRoleService extends AbstractMapper<SysUserRole> {

    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private SysUserRoleBizMapper sysUserRoleBizMapper;

    /**
     * 分页查询列表
     */
    public PageInfoVO getPage(PageParams param) {
        PageHelper.startPage(param.getPage(), param.getSize());
        return new PageInfoVO(this.selectAll());
    }

    /**
     * 保存或更新方法
     */
    public int saveOrUpdate(SysUserRole sysUserRole) {
        if (sysUserRole.getId() == null) {
            return this.insertSelective(sysUserRole);
        } else {
            return this.updateByPrimaryKeySelective(sysUserRole);
        }
    }

    public List<Integer> getUserRoleByUserId(Integer id) {
        return sysUserRoleMapper.getUserRoleByUserId(id);
    }

    public void deleteByUserId(Long id) {
        sysUserRoleMapper.deleteByUserId(id);
    }

    public void insertUserRole(Long userId, List<Integer> roleList) {
        sysUserRoleMapper.insertUserRole(userId, roleList);
    }

}
