package com.onsiteservice.admin.service.sys;

import com.onsiteservice.admin.controller.sys.dto.SysRolePageDTO;
import com.onsiteservice.admin.controller.sys.dto.SysRoleSaveDTO;
import com.onsiteservice.admin.controller.sys.vo.SysBusinessTree;
import com.onsiteservice.admin.controller.sys.vo.SysRoleDetailVO;
import com.onsiteservice.admin.mapper.sys.SysRoleBizMapper;
import com.onsiteservice.admin.mapper.sys.SysRoleOperateBizMapper;
import com.onsiteservice.common.runner.InitDataRunner;
import com.onsiteservice.constant.constant.DictConstants;
import com.onsiteservice.core.exception.ServiceException;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.mapper.sys.SysBusinessMapper;
import com.onsiteservice.dao.mapper.sys.SysRoleMapper;
import com.onsiteservice.dao.mapper.sys.SysRoleOperateMapper;
import com.onsiteservice.dao.util.EntityUtils;
import com.onsiteservice.entity.sys.*;
import com.onsiteservice.util.ArrayUtils;
import com.onsiteservice.util.CommonUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Condition;

import javax.annotation.Resource;
import java.util.*;

/**
 * @author wang jianguo
 * @date 2021-07-22 17:42
 * SysRoleService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SysRoleService extends AbstractMapper<SysRole> {

    @Resource
    private SysRoleMapper sysRoleMapper;
    @Resource
    private SysRoleBizMapper sysRoleBizMapper;
    @Resource
    private SysBusinessMapper sysBusinessMapper;
    @Resource
    private SysBusinessOperateService sysBusinessOperateService;
    @Resource
    private SysRoleOperateBizMapper sysRoleOperateBizMapper;
    @Resource
    private SysRoleOperateService sysRoleOperateService;


    static void getMenuList(List<SysBusinessTree> menuList, Map<String, SysBusinessTree> menuMap, List<SysBusiness> businessList) {
        for (SysBusiness item : businessList) {
            if (menuMap.containsKey(item.getParentCode())) {
                SysBusinessTree voMenu = menuMap.get(item.getParentCode());
                if (voMenu.getChildren() == null) {
                    voMenu.setChildren(new ArrayList<>());
                }
                voMenu.getChildren().add(menuMap.get(item.getCode()));
            } else {
                menuList.add(menuMap.get(item.getCode()));
            }
        }
    }

    /**
     * 分页查询
     *
     * @param sysRolePageDTO
     * @return com.anplus.admin.dto.SysRolePageVo
     * @author linxianghua
     * @date 2019/10/12 10:39
     */
    public List<SysRole> getPage(SysRolePageDTO sysRolePageDTO) {
        return sysRoleBizMapper.getPage(sysRolePageDTO);
    }

    /**
     * 详情
     *
     * @param id
     * @return com.anplus.admin.dto.SysRolePageVo
     * @author linxianghua
     * @date 2019/10/12 10:39
     */
    public SysRoleDetailVO getDetail(Integer id) {
        SysRoleDetailVO vo = new SysRoleDetailVO();
        vo.setCodeMap(Map.of(DictConstants.AVAILABLE_STATUS, InitDataRunner.dictData.get(DictConstants.AVAILABLE_STATUS)));
        List<SysBusinessTree> menuList = new ArrayList<>();
        Map<String, SysBusinessTree> menuMap = new HashMap<>();
        List<SysRoleOperate> operateSelectedList = new ArrayList<>();
        List<SysBusiness> businessList = sysBusinessMapper.selectAll();
        List<SysBusinessOperate> operateList = sysBusinessOperateService.selectAll();
        if (CommonUtils.isZero(id)) {
            SysRole sysRole = new SysRole();
            sysRole.setIsEnabled(true);
            vo.setSysRole(sysRole);
        } else {
            vo.setSysRole(selectByPrimaryKey(id));
            Condition condition = new Condition(SysRoleOperate.class);
            condition.createCriteria().andCondition("role_id = " + Long.valueOf(id));
            operateSelectedList = sysRoleOperateService.selectByCondition(condition);
            Map<Long, SysBusinessOperate> operateMap = new HashMap<>();
            for (SysBusinessOperate operate : operateList) {
                operateMap.put(operate.getId(), operate);
            }
            for (SysRoleOperate roleOperate : operateSelectedList) {
                if (operateMap.containsKey(roleOperate.getBusinessOperateId())) {
                    SysBusinessOperate businessOperate = operateMap.get(roleOperate.getBusinessOperateId());
                    businessOperate.setSelected(true);
                }
            }
        }
        for (SysBusiness item : businessList) {
            SysBusinessTree sysBusinessTree = new SysBusinessTree(item);
            sysBusinessTree.setSysBusinessOperateList(new ArrayList<>());
            for (SysBusinessOperate sysBusinessOperate : operateList) {
                if (sysBusinessOperate.getBusinessId().equals(item.getId())) {
                    if (operateSelectedList.size() > 0) {
                        for (SysRoleOperate sysRoleOperate : operateSelectedList) {
                            if (sysRoleOperate.getBusinessOperateId().equals(sysBusinessOperate.getId())) {
                                sysBusinessOperate.setSelected(true);
                            }
                        }
                    }
                    sysBusinessTree.getSysBusinessOperateList().add(sysBusinessOperate);
                }
            }
            menuMap.put(item.getCode(), sysBusinessTree);
        }

        getMenuList(menuList, menuMap, businessList);

        vo.setSysBusinessTreeList(menuList);
        return vo;
    }

    /**
     * @param param
     * @return java.lang.Long
     * @author linxianghua
     * @date 2019/10/14 14:57
     */
    public Long saveRole(SysRoleSaveDTO param, Long userId) {
        SysRole sysRole = param.getSysRole();
        if (sysRoleBizMapper.getRepeat(sysRole.getId(), sysRole.getCode()) > 0) {
            throw new ServiceException("编号重复！");
        }
        //根据数据有无id判断是新建还是修改
        if (CommonUtils.isZero(sysRole.getId())) {
            sysRole.setCreateBy(userId);
            insertSelective(sysRole);
        } else {
            EntityUtils.update(sysRole, userId);
            updateByPrimaryKeySelective(sysRole);
            Condition condition = new Condition(SysRoleOperate.class);
            condition.createCriteria().andCondition("role_id=" + sysRole.getId());
            sysRoleOperateService.deleteByCondition(condition);
        }
        if (param.getSaveOperatedList().size() > 0) {
            sysRoleOperateBizMapper.insertBatch(sysRole.getId(), param.getSaveOperatedList());
        }
        return sysRole.getId();
    }

    /**
     * 查询所以可用角色
     *
     * @param
     * @return java.util.List<com.dao.model.sys.SysRole>
     * @author wangning
     * @date 2019-10-16 16:58
     */
    public List<SysRole> getAllAvailableRole() {
        return sysRoleBizMapper.getAllAvailableRole();
    }

    /**
     * 更改用户启用状态
     *
     * @param id
     * @return java.lang.Long
     * @author linxianghua
     * @date 2019/11/14 11:37
     */
    public Long changeStatus(Long id) {
        SysRole sysRole = selectByPrimaryKey(id);
        sysRole.setIsEnabled(!sysRole.getIsEnabled());

        if (!sysRole.getIsEnabled()) {
            // 如果是禁用，则校验是否已经关联用户
            if (sysRoleBizMapper.getRoleUserNum(id) > 0) {
                throw new ServiceException("该角色已经关联用户，不能禁用");
            }
        }
        updateByPrimaryKeySelective(sysRole);
        return sysRole.getId();
    }
}
