package com.onsiteservice.admin.service.sys;

import com.onsiteservice.admin.controller.sys.dto.SysParamDTO;
import com.onsiteservice.admin.controller.sys.vo.SysParamVO;
import com.onsiteservice.admin.mapper.sys.SysParamBizMapper;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.util.EntityUtils;
import com.onsiteservice.entity.sys.SysParam;
import com.onsiteservice.entity.sys.SysUser;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author wang jianguo
 * @date 2021-07-23 17:45
 * SysParamService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SysParamService extends AbstractMapper<SysParam> {

    @Resource
    private SysParamBizMapper sysParamBizMapper;

    /**
     * 分页查询总控系统参数列表
     *
     * @param sysParamDTO
     * @return
     */
    public List<SysParamVO> queryForPage(SysParamDTO sysParamDTO) {
        return sysParamBizMapper.getPage(sysParamDTO);
    }


    public void updateParam(SysParam sysParam, Long userId) {
        EntityUtils.update(sysParam, userId);
        this.updateByPrimaryKeySelective(sysParam);
    }
}
