package com.onsiteservice.admin.service.sys;

import com.github.pagehelper.PageHelper;
import com.onsiteservice.admin.mapper.sys.SysDictBizMapper;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.dao.mapper.sys.SysDictMapper;
import com.onsiteservice.entity.sys.SysDict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * @author wang jianguo
 * @date 2021-07-23 10:37
 * SysDictService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SysDictService extends AbstractMapper<SysDict> {

    @Resource
    private SysDictMapper sysDictMapper;
    @Resource
    private SysDictBizMapper sysDictBizMapper;

    /**
     * 分页查询列表
     */
    public PageInfoVO getPage(PageParams param) {
        PageHelper.startPage(param.getPage(), param.getSize());
        return new PageInfoVO(this.selectAll());
    }

    /**
     * 保存或更新方法
     */
    public int saveOrUpdate(SysDict sysDict) {
        if (sysDict.getId() == null) {
            return this.insertSelective(sysDict);
        } else {
            return this.updateByPrimaryKeySelective(sysDict);
        }
    }
}
