package com.onsiteservice.admin.service.service;

import com.onsiteservice.entity.service.ServicePromote;
import com.onsiteservice.dao.mapper.service.ServicePromoteMapper;
import com.onsiteservice.admin.mapper.service.ServicePromoteBizMapper;

import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.github.pagehelper.PageHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * @author 商天翔
 * @date 2022-07-21 15:55
 * @description ServicePromoteService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class ServicePromoteService extends AbstractMapper<ServicePromote> {

    @Resource
    private ServicePromoteBizMapper servicePromoteBizMapper;

    /**
     * 分页查询列表
     */
    public PageInfoVO getPage(PageParams param) {
        PageHelper.startPage(param.getPage(), param.getSize());
        return new PageInfoVO(servicePromoteBizMapper.getPage(param));
    }

}
