package com.onsiteservice.admin.service.home;

import com.onsiteservice.dao.util.EntityUtils;
import com.onsiteservice.entity.home.HomeNotice;
import com.onsiteservice.dao.mapper.home.HomeNoticeMapper;
import com.onsiteservice.admin.mapper.home.HomeNoticeBizMapper;

import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.github.pagehelper.PageHelper;
import lombok.Getter;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * @author 商天翔
 * @date 2022-07-20 16:19
 * @description HomeNoticeService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class HomeNoticeService {

    @Resource
    @Getter
    private HomeNoticeMapper homeNoticeMapper;
    @Resource
    private HomeNoticeBizMapper homeNoticeBizMapper;

    /**
     * 分页查询列表
     */
    public PageInfoVO getPage(PageParams param) {
        PageHelper.startPage(param.getPage(), param.getSize());
        return new PageInfoVO(homeNoticeBizMapper.getPage(param));
    }

    /**
     * 保存或更新方法
     */
    public int saveOrUpdate(HomeNotice homeNotice, Long userId) {
        if (homeNotice.getId() == null) {
            EntityUtils.insert(homeNotice,userId);
            return homeNoticeMapper.insertSelective(homeNotice);
        } else {
            EntityUtils.update(homeNotice,userId);
            return homeNoticeMapper.updateByPrimaryKeySelective(homeNotice);
        }
    }
}
