package com.onsiteservice.admin.service.category;

import com.onsiteservice.admin.controller.category.dto.ServiceCategoryDTO;
import com.onsiteservice.admin.controller.category.vo.CategoryVO;
import com.onsiteservice.admin.controller.category.vo.ServiceItemVO;
import com.onsiteservice.admin.mapper.service.ServiceSubclassBizMapper;
import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.mapper.service.ServiceCategoryMapper;
import com.onsiteservice.admin.mapper.service.ServiceCategoryBizMapper;

import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.github.pagehelper.PageHelper;
import com.onsiteservice.dao.util.EntityUtils;
import com.onsiteservice.entity.category.ServiceCategory;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.swing.text.html.parser.Entity;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author 商天翔
 * @date 2022-07-13 17:03
 * @description ServiceCategoryService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class ServiceCategoryService extends AbstractMapper<ServiceCategory> {

    private ServiceCategoryMapper serviceCategoryMapper;
    private ServiceCategoryBizMapper serviceCategoryBizMapper;
    private ServiceSubclassBizMapper serviceSubclassBizMapper;

    /**
     * 保存或更新方法
     */
    public int saveOrUpdate(ServiceCategory serviceCategory, @CurrentUserId Long userId) {
        EntityUtils.update(serviceCategory, userId);
        return this.updateByPrimaryKeySelective(serviceCategory);
    }

    public List<CategoryVO> getCategoryList(ServiceCategoryDTO dto) {
        List<CategoryVO> categories = serviceCategoryBizMapper.getAll();
        // 获取服务小类
        List<ServiceItemVO> subItems = serviceSubclassBizMapper.getSubClasses(dto);
        Map<Integer, List<ServiceItemVO>> subMap = subItems.stream().collect(Collectors.groupingBy(ServiceItemVO::getCategoryId));
        categories.forEach((category) -> category.setChildren(subMap.get(category.getId())));
        return categories;
    }
}
