package com.onsiteservice.admin.security.pojo;


import com.onsiteservice.util.ReflectUtils;
import lombok.Getter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

import java.util.Collection;

/**
 * @author 潘维吉
 * @date 2020/3/5 13:57
 * @email 406798106@qq.com
 * @description 自定义用户信息 用于直接返回更多数据给前端 用户信息和权限
 */
@Getter
public class CustomUserDetails extends User {

    /**
     * 业务系统自定义用户实体属性 根据业务命名定义修改
     */
    public static final String ID = "id";
    public static final String COMPANY_ID = "companyId";
    public static final String USERNAME = "userName";
    public static final String REAL_NAME = "realName";
    public static final String PASSWORD = "password";
    public static final String AVATAR = "avatarUrl";
    public static final String IS_ENABLED = "isEnabled";
    public static final String IS_GOD = "isGod";
    public static final String IS_SUPER_GOD = "isSuperGod";
    private static final long serialVersionUID = 1167013428315310807L;
    private Long userId;
    private Long companyId;
    private String realName;
    private String avatarUrl;
    //private List permissionList;

    public CustomUserDetails(String username, String password, Collection<? extends GrantedAuthority> authorities) {
        super(username, password, authorities);
    }

    public CustomUserDetails(Object user, Collection<? extends GrantedAuthority> authorities) {
        super(ReflectUtils.invokeGetter(user, USERNAME), ReflectUtils.invokeGetter(user, PASSWORD), authorities);
        this.userId = ReflectUtils.invokeGetter(user, ID);
        this.companyId = ReflectUtils.invokeGetter(user, COMPANY_ID);
        this.realName = ReflectUtils.invokeGetter(user, REAL_NAME);
        this.avatarUrl = ReflectUtils.invokeGetter(user, AVATAR);
    }

    public CustomUserDetails(String username, String password, boolean enabled, boolean accountNonExpired,
                             boolean credentialsNonExpired, boolean accountNonLocked, Collection<? extends GrantedAuthority> authorities) {
        super(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
    }


}
